<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Ultimate_AI_Faq
{
    private $cpt_type = 'uai_cpt_faq';
    private $meta_key = 'uai_faq';

    public function __construct()
    {
    }

    public function ultimate_ai_create_faq($question, $answer, $id = 0)
    {
        if ($id == 0) {
            $faq_data = $this->ultimate_ai_get_faq_data_boilerplate();
        } else {
            $faq_data = get_post_meta($id, $this->meta_key, true);
        }

        $faq_data['question'] = $question;
        $faq_data['answer'] = $answer;
        if (!empty($question)) {
            $faq_data['question'] = $question;
        }
        if (!empty($answer)) {
            $faq_data['answer'] = $answer;
        }
        $user = wp_get_current_user();
        $cpt_args = [
            'ID' => $id,
            'post_type' => $this->cpt_type,
            'post_author' => $user->ID,
            'post_content' => '',
            'post_title' => $question,
            'post_status' => 'publish',
            'meta_input' => [
                'uai_faq' => $faq_data,
                'is_active' => $faq_data['is_active'],
            ],
        ];
        $res = wp_insert_post($cpt_args);
        if (is_wp_error($res) || $res == 0) {
            return ['is_success' => false, 'message' => $res->get_error_message() ?? __('unknown message', ULTIMATE_AI_SLUG)];
        }

        return ['is_success' => true, 'data' => $faq_data];
    }

    public function ultimate_ai_get_all_faqs($filter_array = [])
    {
        $args = [
            'post_type' => $this->cpt_type,
            'post_status' => 'publish',
            'posts_per_page' => -1, // all
        ];

        $args = array_merge($filter_array, $args);

        $the_query = new WP_Query($args);
        $faq_items = [];
        if ($the_query->have_posts()) {
            while ($the_query->have_posts()) {
                $the_query->the_post();
                $single_faq_data = get_post_meta(get_the_ID(), $this->meta_key, true);
                $single_faq_data['date'] = get_post_time('U', false, get_the_ID(), false);
                $single_faq_data['id'] = get_the_ID();
                $faq_items[] = $single_faq_data;
            }
        }

        return ['faq' => $faq_items, 'total_faqs' => $the_query->found_posts];
    }

    public function ultimate_ai_update_faq_meta($key_name, $value, $faq_id, $is_direct_meta = false)
    {
        $chat_assistant = get_post_meta($faq_id, $this->meta_key, true);

        if (!$chat_assistant) {
            return ['is_success' => false, 'message' => __('Chat assistant meta not found', ULTIMATE_AI_SLUG)];
        }
        $chat_assistant[$key_name] = $value;
        $is_success = update_post_meta($faq_id, $this->meta_key, $chat_assistant);
        if ($is_direct_meta) {
            $is_success = update_post_meta($faq_id, $key_name, $value);
        }
        if (!$is_success) {
            return ['is_success' => false, 'message' => __('Chat assistant update fail', ULTIMATE_AI_SLUG)];
        }

        return ['is_success' => true, 'data' => $chat_assistant];
    }

    public function ultimate_ai_delete_faq_item($faq_id)
    {
        $is_success = wp_delete_post($faq_id);
        if (!$is_success) {
            return ['success' => false, 'message' => __('Faq deletion fail', ULTIMATE_AI_SLUG)];
        }

        return ['success' => true, 'data' => 'Faq deleted'];
    }

    private function ultimate_ai_get_faq_data_boilerplate()
    {
        return [
            'question' => 'Unknown tool',
            'answer' => 'Make your work faster with ai',
            'is_active' => true,
        ];
    }
}
